﻿<?php
/**
 * Template Name: Contact Coach
 */

get_header();

// Récupérer l'ID du coach depuis l'URL
$coach_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($coach_id) {
    $coach_post = get_post($coach_id);

    if ($coach_post) {
        // Nom du coach (titre du cours)
        $coach_name = get_the_title($coach_post);

        // Photo du coach (image mise en avant du cours)
        $coach_photo = get_the_post_thumbnail($coach_post, 'medium');

        // Nombre d'avis + moyenne des notes (Tutor LMS)
        $rating_data = tutor_utils()->get_course_rating($coach_id);
        $average_rating = $rating_data->rating_avg ?? 0;
        $rating_count   = $rating_data->rating_count ?? 0;
        $course_price = tutor_utils()->get_course_price($coach_id);
        ?>
        
        <div class="tutor-course-details-page tutor-container">
		<?php ( isset( $is_enrolled ) && $is_enrolled ) ? tutor_course_enrolled_lead_info() : tutor_course_lead_info(); ?>
		
		<div class="tutor-row tutor-gx-xl-5">
		<aside class="tutor-col-xl-4"><div class="coach-info" >
                <div class="coach-photo">
                    <?php echo $coach_photo; ?>
                    <?php echo $course_price;?>
                    <div class="parh"> /h</div>
                    <div> </div>
                </div>
                <div class="coach-details" >
                
                    <h2><?php echo esc_html($coach_name); ?></h2>
                  	<?php echo do_shortcode('[site_reviews_summary assigned_posts="' . esc_attr($course_id) . '"]');?>
                </div>
            </div></aside>
			<main class="tutor-col-xl-8">
			  <div class="coach-contact-form">
                <h3>Programmez </h3>
                <h2>votre premier Coaching</h2>
             
                <?php
                // Afficher ton formulaire Contact Form 7 avec paiement intégré
                 
                echo do_shortcode('[fluentform id="9"]');
                ?>
            </div>
			</main>
			</div>
        
      

        <?php
    } else {
        echo "<p>Coach introuvable.</p>";
    }
} else {
    echo "<p>Aucun coach sélectionné.</p>";
}

get_footer();
