<?php
/**
 * Template for displaying course reviews
 * Personnalisé pour permettre les avis sans compte
 */

use TUTOR\Input;

$disable = ! get_tutor_option( 'enable_course_review' );
if ( $disable ) {
    return;
}

global $is_enrolled, $course_rating;

$per_page     = tutor_utils()->get_option( 'pagination_per_page', 10 );
// Utiliser $_GET pour la page actuelle lors du chargement initial de la page
$current_page = max( 1, Input::get( 'current_page', 0, Input::TYPE_INT ) );
$offset       = ( $current_page - 1 ) * $per_page;

$current_user_id = get_current_user_id();
// Utiliser $_GET pour l'ID du cours lors du chargement initial de la page
$course_id       = Input::get( 'course_id', get_the_ID(), Input::TYPE_INT );

// Récupérer les avis approuvés
$reviews         = tutor_utils()->get_course_reviews( $course_id, $offset, $per_page, false, array( 'approved' ) );
$reviews_total   = tutor_utils()->get_course_reviews( $course_id, null, null, true, array( 'approved' ) );

// Récupérer l'avis de l'utilisateur actuel (s'il est connecté)
$my_rating       = tutor_utils()->get_reviews_by_user( 0, 0, 150, false, $course_id, array( 'approved', 'hold' ) );

// Cette condition est probablement pour AJAX, nous laissons pour l'instant
if ( Input::has( 'course_id' ) && !is_admin() ) {
    tutor_load_template( 'single.course.reviews-loop', array( 'reviews' => $reviews ) );
    return;
}

if ( is_null( $is_enrolled ) ) {
    $is_enrolled = tutor_utils()->is_enrolled( $course_id, $current_user_id );
}

// MODIFICATION: Autoriser les avis même sans être inscrit
$allow_reviews_without_enrollment = true;

if ( is_null( $course_rating ) ) {
    $course_rating = tutor_utils()->get_course_rating( $course_id );
}

do_action( 'tutor_course/single/enrolled/before/reviews' );

// Afficher les messages de statut depuis les transients
$status  = get_transient('tutor_review_status');
$message = get_transient('tutor_review_message');

if ($status && $message) {
    if ($status === 'success') {
        echo '<div class="tutor-alert tutor-alert-success tutor-mb-24">' . esc_html($message) . '</div>';
    } elseif ($status === 'error') {
        echo '<div class="tutor-alert tutor-alert-danger tutor-mb-24">' . esc_html($message) . '</div>';
    }
    
    // Nettoyer les transients
    delete_transient('tutor_review_status');
    delete_transient('tutor_review_message');
}
echo do_shortcode('[site_reviews assigned_posts="' . esc_attr($course_id) . '"]');
?>

<h3 class="tutor-mt-16">Ajouter un avis</h3>
<?php
echo do_shortcode('[site_reviews_form assigned_posts="' . esc_attr($course_id) . '"]');




?>


<?php do_action( 'tutor_course/single/enrolled/after/reviews' ); ?>