<?php

if (!defined('ABSPATH'))
	exit; // Exit if accessed directly

/**
 * Module Name: Cross-Sell Products
 * Description: 
 */
class TB_Crosssell_Products_Module extends Themify_Builder_Component_Module {

	public static function is_available():bool{
		return themify_is_woocommerce_active();
	}

	public static function get_module_name():string {
		return __('Cross-sells Products', 'tbp');
	}

	public static function get_module_icon():string {
		return 'list';
	}

	public function __construct() {//backward
		if (method_exists('Themify_Builder_Model', 'add_module')) {
			parent::__construct('crosssell-products');
		} else {//backward
			parent::__construct(array(
				'name' => $this->get_name(),
				'slug' => 'crosssell-products',
				'category' => $this->get_group()
			));
		}
	}

	/**
	 * Render plain content for static content.
	 */
	public static function get_static_content(array $module):string {
		return '';
	}

    public static function get_styling_image_fields() : array {
        return [
            'b_i' => ''
        ];
    }
}


if (!method_exists( 'Themify_Builder_Component_Module', 'get_module_class' ) && TB_Crosssell_Products_Module::is_available()) {
	if (method_exists('Themify_Builder_Model', 'add_module')) {
		new TB_Crosssell_Products_Module();
	} else {
		Themify_Builder_Model::register_module('TB_Crosssell_Products_Module');
	}
}
