<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Module Name: Cart Items
 * Description: 
 */
class TB_Cart_Items_Module extends Themify_Builder_Component_Module {

	public static function init():void{
	}

	public static function is_available():bool{
		return themify_is_woocommerce_active();
	}

	public static function get_module_name():string {
		return __('Cart Items', 'tbp');
	}

	public static function get_module_icon():string {
		return 'shopping-cart';
	}

	public static function get_js_css():array{
		return array(
			'ver' => TBP_VER,
			'css' => TBP_WC_CSS_MODULES . 'cart-items'
		);
	}

	/**
	 * Render plain content for static content.
	 */
	public static function get_static_content(array $module):string {
		return '';
	}

	public static function get_translatable_text_fields( $module ) : array {
		return [ 'lbl_name', 'lbl_price', 'lbl_quantity', 'lbl_subtotal' ];
	}

    public static function get_styling_image_fields() : array {
        return [];
    }
}