<?php
/**
 * Builder Plugin Compatibility Code
 *
 * @package    Themify_Builder Pro
 */
/**
 * @link https://woocommerce.com/products/google-product-feed/
 */
class Themify_Builder_Plugin_Compat_wooProductFeeds {

	static function init() {
		add_action( 'woocommerce_before_single_product', array( __CLASS__, 'woocommerce_before_single_product' ) );
	}

	/**
	 * Fix missing product schema generated by GPF
	 */
	static function woocommerce_before_single_product() {
		$tbp_locations = Tbp_Public::get_location();
		if ( ! empty( $tbp_locations['product_single'] ) ) {
			global $woocommerce_gpf_di;
			if ( ! empty( $woocommerce_gpf_di['WoocommerceProductFeedsExpandedStructuredData'] ) ) {
				$woocommerce_gpf_di['WoocommerceProductFeedsExpandedStructuredData']->generate_schema_products();
			}
		}
	}
}