<?php
/**
 * @package         FireBox
 * @version         2.1.32 Pro
 * 
 * @author          FirePlugins <info@fireplugins.com>
 * @link            https://www.fireplugins.com
 * @copyright       Copyright © 2025 FirePlugins All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace FireBox\Core\Admin\Forms\FireBox;

if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly.
}

use \FPFramework\Base\Functions;

class PHPScripts
{
	/**
	 * Holds the PHP Scripts Settings
	 * 
	 * @return  array
	 */
	public function getSettings()
	{
		$settings = [
			'title' => firebox()->_('FB_PHPSCRIPTS'),
			'content' => [
				'phpscripts_render' => [
					'title' => [
						'title' => fpframework()->_('FPF_RENDER'),
						'description' => firebox()->_('FB_METABOX_PHPSCRIPTS_RENDER_DESC')
					],
					'fields' => [
						[
							'name' => 'phpscripts.beforerender',
							'type' => 'Textarea',
							'label' => firebox()->_('FB_PHPSCRIPTS_BEFORERENDER'),
							'description' => sprintf(firebox()->_('FB_PHPSCRIPTS_BEFORERENDER_DESC'), Functions::getUTMURL('https://www.fireplugins.com/docs/firebox/working-with-php-scripts/#before_render', '', 'misc', 'php-scripts-before-render')),
							'input_class' => ['fullwidth'],
							'rows' => 10,
							'filter' => 'php',
							'mode' => 'text/x-php'
						],
						[
							'name' => 'phpscripts.afterrender',
							'type' => 'Textarea',
							'label' => firebox()->_('FB_PHPSCRIPTS_AFTERRENDER'),
							'description' => sprintf(firebox()->_('FB_PHPSCRIPTS_AFTERRENDER_DESC'), Functions::getUTMURL('https://www.fireplugins.com/docs/firebox/working-with-php-scripts/#after_render', '', 'misc', 'php-scripts-after-render')),
							'input_class' => ['fullwidth'],
							'rows' => 10,
							'filter' => 'php',
							'mode' => 'text/x-php'
						],
					]
				],
				'phpscripts_state' => [
					'wrapper' => [
						'showon' => '[mode]!:embed',
					],
					'title' => [
						'title' => fpframework()->_('FPF_STATE'),
						'description' => firebox()->_('FB_METABOX_PHPSCRIPTS_STATE_DESC')
					],
					'fields' => [
						[
							'name' => 'phpscripts.open',
							'type' => 'Textarea',
							'label' => firebox()->_('FB_PHPSCRIPTS_OPEN'),
							'description' => sprintf(firebox()->_('FB_PHPSCRIPTS_OPEN_DESC'), Functions::getUTMURL('https://www.fireplugins.com/docs/firebox/working-with-php-scripts/#open', '', 'misc', 'php-scripts-open')),
							'input_class' => ['fullwidth'],
							'rows' => 10,
							'filter' => 'php',
							'mode' => 'text/x-php'
						],
						[
							'name' => 'phpscripts.close',
							'type' => 'Textarea',
							'label' => firebox()->_('FB_PHPSCRIPTS_CLOSE'),
							'description' => sprintf(firebox()->_('FB_PHPSCRIPTS_CLOSE_DESC'), Functions::getUTMURL('https://www.fireplugins.com/docs/firebox/working-with-php-script/#close', '', 'misc', 'php-scripts-close')),
							'input_class' => ['fullwidth'],
							'rows' => 10,
							'filter' => 'php',
							'mode' => 'text/x-php'
						],
					]
				],
				'phpscripts_form' => [
					'title' => [
						'title' => firebox()->_('FB_FORM'),
						'description' => firebox()->_('FB_METABOX_PHPSCRIPTS_FORM_DESC')
					],
					'fields' => [
						[
							'name' => 'phpscripts.formprocess',
							'type' => 'Textarea',
							'label' => firebox()->_('FB_PHPSCRIPTS_FORM_PROCESS'),
							'description' => sprintf(firebox()->_('FB_PHPSCRIPTS_FORM_PROCESS_DESC'), Functions::getUTMURL('https://www.fireplugins.com/docs/firebox/working-with-php-scripts/#formprocess', '', 'misc', 'php-scripts-form-process')),
							'input_class' => ['fullwidth'],
							'rows' => 10,
							'filter' => 'php',
							'mode' => 'text/x-php'
						],
						[
							'name' => 'phpscripts.formsuccess',
							'type' => 'Textarea',
							'label' => firebox()->_('FB_PHPSCRIPTS_FORM_SUCCESS'),
							'description' => sprintf(firebox()->_('FB_PHPSCRIPTS_FORM_SUCCESS_DESC'), Functions::getUTMURL('https://www.fireplugins.com/docs/firebox/working-with-php-scripts/#formsuccess', '', 'misc', 'php-scripts-form-success')),
							'input_class' => ['fullwidth'],
							'rows' => 10,
							'filter' => 'php',
							'mode' => 'text/x-php'
						],
					]
				]
			]
		];

		return apply_filters('firebox/box/settings/phpscripts/edit', $settings);
	}
}