<?php
/**
 * Template Counter
 * 
 * Access original fields: $args['mod_settings']
 */
defined( 'ABSPATH' ) || exit;

$mod_name = $args['mod_name'];
$element_id=$args['module_ID'];
$fields_args = $args['mod_settings']+ array(
	'mod_title_counter' => '',
	'number_grouping' => '',
	'number_counter' => '',
	'label_counter' => '',
	'circle_percentage_counter' => '',
	'circle_stroke_counter' => 2,
	'circle_color_counter' => 'ccc',
	'circle_background_counter' => '',
	'size_counter' => 'medium',
	'add_css_counter' => '',
	'animation_effect' => ''
);
$container_class = apply_filters('themify_builder_module_classes', array(
	'module', 'module-' . $mod_name, $element_id, 'size-' . $fields_args['size_counter'], $fields_args['add_css_counter'], 'tf_textc', self::parse_animation_effect($fields_args['animation_effect'], $fields_args)
	), $mod_name, $element_id, $fields_args);
if (!empty($fields_args['global_styles']) && Themify_Builder::$frontedit_active === false) {
	$container_class[] = $fields_args['global_styles'];
}
preg_match('/([\D]*)([\d\.]*)([\D]*)/', (string) $fields_args['number_counter'], $parts);
$prefix = $parts[1];
$number = $parts[2];
$suffix = $parts[3];
$counter = explode('.', (string) $number);
$decimals = isset($counter[1]) ? strlen($counter[1]) : 0;

$container_props = apply_filters('themify_builder_module_container_props', array(
	'class' => implode(' ', $container_class),
	), $fields_args, $mod_name, $element_id);
if (Themify_Builder::$frontedit_active === false) {
	$container_props['data-lazy'] = 1;
}
$isCircle = '' !== $fields_args['circle_percentage_counter'];
?>
<!-- module counter -->
<div <?php echo self::get_element_attributes(self::sticky_element_props($container_props, $fields_args)); ?>>
	<?php
	$container_props = $container_class = $args = null;
	if (method_exists('Themify_Builder_Component_Module', 'get_module_title')) {
		echo Themify_Builder_Component_Module::get_module_title($fields_args, 'mod_title_counter');
	} elseif ($fields_args['mod_title_counter'] !== '') {
		echo $fields_args['before_title'], apply_filters('themify_builder_module_title', $fields_args['mod_title_counter'], $fields_args), $fields_args['after_title'];
	}
	do_action('themify_builder_before_template_content_render');
	?>
	<?php if ($isCircle === true) : ?>

		<div class="counter-chart tf_rel">
			<svg class="tf_abs tf_w tf_h">
			<?php if ('' !== $fields_args['circle_background_counter']) : ?>
				<circle fill="<?php echo Themify_Builder_Stylesheet::get_rgba_color($fields_args['circle_background_counter']); ?>" class="module-counter-background"></circle>
			<?php endif; ?>
			<circle class="tb_counter_fill" stroke="rgba(0,0,0,.1)" stroke-width="<?php echo $fields_args['circle_stroke_counter'] > 0 ? $fields_args['circle_stroke_counter'] : 0; ?>"/>
			<circle class="tb_counter_stroke" stroke-width="<?php echo $fields_args['circle_stroke_counter'] > 0 ? $fields_args['circle_stroke_counter'] : 0; ?>" stroke="<?php echo Themify_Builder_Stylesheet::get_rgba_color($fields_args['circle_color_counter']) ?>" data-progress="<?php echo (int) $fields_args['circle_percentage_counter'] ?>" stroke-dasharray="0,10000"/>
			</svg>
		<?php endif; ?>
		<div class="number<?php if ($isCircle === true): ?> tf_abs_c<?php endif; ?>">
			<span class="bc-timer"
				  data-to="<?php echo $number; ?>"
				  data-suffix="<?php echo $suffix; ?>"
				  data-prefix="<?php echo $prefix; ?>"
				  data-decimals="<?php echo $decimals; ?>"
				  data-grouping="<?php echo $fields_args['number_grouping']; ?>"></span>
		</div>

		<?php if ($isCircle === true) : ?>
		</div><!-- .chart -->
	<?php endif; ?>

    <div class="counter-text"><?php echo $fields_args['label_counter']; ?></div>

	<?php do_action('themify_builder_after_template_content_render'); ?>
</div>
<!-- /module counter -->
