<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Module Name: Counter
 */

class TB_Counter_Module extends Themify_Builder_Component_Module {

    public static function get_module_name():string{
		add_filter( 'themify_builder_active_vars', [ __CLASS__, 'builder_active_enqueue' ] );
        return __('Counter', 'builder-counter');
    }
	
	public static function get_json_file():array{
		return ['f'=>Builder_Counter::$url . 'json/style.json','v'=>Builder_Counter::get_version()];
	}

    public static function get_module_icon():string{
		return 'pie-chart';
    }

    public static function get_js_css():array {
		return array(
		   'async'=>true,
		   'css' => Builder_Counter::$url . 'assets/style',
		   'js' => Builder_Counter::$url . 'assets/scripts',
		   'ver' => Builder_Counter::get_version()
		);
    }

	public static function builder_active_enqueue(array $vars ):array {
		if(!isset($vars['addons'])){//backward
			themify_enque_script( 'tb_builder-counter', Builder_Counter::$url . 'assets/active.js', Builder_Counter::get_version(), [ 'themify-builder-app-js' ] );
		}
		else{
			$vars['addons'][Builder_Counter::$url . 'assets/active.js']=Builder_Counter::get_version();
		}

		$i18n = include dirname( __DIR__ ) . '/includes/i18n.php';
		$vars['i18n']['label']+= $i18n;

		return $vars;
	}

	/**
	 * Deprecated methods
	 */
    public function __construct() {
        if(method_exists('Themify_Builder_Model', 'add_module')){
            parent::__construct('counter');
        }
        else{//backward
             parent::__construct(array(
                'name' =>$this->get_name(),
                'slug' => 'counter',
                'category' =>$this->get_group()
            ));
        }
    }

    public function get_name(){
		return self::get_module_name();
    }

    public function get_icon(){
		return self::get_module_icon();
    }

    function get_assets() {
		return self::get_js_css();
    }

    public function get_styling() {
        $general = array(
            //bacground
	    self::get_expand('bg', array(
		self::get_tab(array(
		    'n' => array(
			'options' => array(
			    self::get_color('', 'background_color','bg_c', 'background-color'),
			)
		    ),
		    'h' => array(
			'options' => array(
			    self::get_color('', 'bg_c', 'bg_c', 'background-color', 'h')
			)
		    )
		))
	    )),
	    self::get_expand('f', array(
		self::get_tab(array(
		    'n' => array(
			'options' => array(
			    self::get_font_family(),
			    self::get_color_type(array(' .number',' .counter-text')),
			    self::get_font_size(),
			    self::get_font_style( '', 'f_fs_g', 'f_fw_g' ),
			    self::get_line_height(),
			    self::get_text_align(),
				self::get_text_shadow(),
			)
		    ),
		    'h' => array(
			'options' => array(
			    self::get_font_family('', 'f_f', 'h'),
			    self::get_color_type(array(' .number',' .counter-text'),'h'),
			    self::get_font_size('', 'f_s', '', 'h'),
				self::get_font_style( '', 'f_fs_g', 'f_fw_g', 'h' ),
				self::get_text_shadow('','t_sh','h'),
			)
		    )
		))
	    )),
	    // Padding
	    self::get_expand('p', array(
		self::get_tab(array(
		    'n' => array(
			'options' => array(
			    self::get_padding()
			)
		    ),
		    'h' => array(
			'options' => array(
			    self::get_padding('', 'p', 'h')
			)
		    )
		))
	    )),
	    // Margin
	    self::get_expand('m', array(
		self::get_tab(array(
		    'n' => array(
			'options' => array(
			    self::get_margin()
			)
		    ),
		    'h' => array(
			'options' => array(
			    self::get_margin('', 'm', 'h')
			)
		    )
		))
	    )),
	    // Border
	    self::get_expand('b', array(
		self::get_tab(array(
		    'n' => array(
			'options' => array(
			    self::get_border()
			)
		    ),
		    'h' => array(
			'options' => array(
			    self::get_border('', 'b', 'h')
			)
		    )
		))
	    )),
		// Width
		self::get_expand('w', array(
			self::get_width('', 'w')
		)),
				// Height & Min Height
				self::get_expand('ht', array(
						self::get_height(),
						self::get_min_height(),
						self::get_max_height()
					)
				),
			// Rounded Corners
			self::get_expand('r_c', array(
					self::get_tab(array(
						'n' => array(
							'options' => array(
								self::get_border_radius()
							)
						),
						'h' => array(
							'options' => array(
								self::get_border_radius('', 'r_c', 'h')
							)
						)
					))
				)
			),
			// Shadow
			self::get_expand('sh', array(
					self::get_tab(array(
						'n' => array(
							'options' => array(
								self::get_box_shadow()
							)
						),
						'h' => array(
							'options' => array(
								self::get_box_shadow('', 'sh', 'h')
							)
						)
					))
				)
			),
			// Display
			self::get_expand('disp', self::get_display())
        );

        $l = array(
            //background
			self::get_expand('bg', array(
				self::get_tab(array(
					'n' => array(
					'options' => array(
						self::get_color(' .counter-text', 'b_c_l','bg_c', 'background-color'),
					)
					),
					'h' => array(
					'options' => array(
						self::get_color(' .counter-text', 'bg_c_l', 'bg_c', 'background-color', 'h')
					)
					)
				))
			)),
			self::get_expand('f', array(
				self::get_tab(array(
					'n' => array(
					'options' => array(
						self::get_font_family(' .counter-text','f_f_l'),
						self::get_color_type(' .counter-text', 'f_c_l'),
						self::get_font_size(' .counter-text','f_s_l'),
						self::get_font_style(' .counter-text', 'f_st_l', 'f_fw_l' ),
						self::get_line_height(' .counter-text','l_h_l'),
						self::get_text_align(' .counter-text', 't_a_l'),
						self::get_text_shadow(' .counter-text','t_sh_l'),
					)
					),
					'h' => array(
					'options' => array(
						self::get_font_family(' .counter-text', 'f_f_l', 'h'),
						self::get_color_type(' .counter-text','f_c_l','h'),
						self::get_font_size(' .counter-text', 'f_s_l', '', 'h'),
						self::get_font_style(' .counter-text', 'f_st_l', 'f_fw_l', 'h' ),
						self::get_text_shadow(' .counter-text','t_sh_l','h'),
					)
					)
				))
			)),
			// Padding
			self::get_expand('p', array(
				self::get_tab(array(
					'n' => array(
					'options' => array(
						self::get_padding(' .counter-text', 'p_l')
					)
					),
					'h' => array(
					'options' => array(
						self::get_padding(' .counter-text', 'p_l', 'h')
					)
					)
				))
			)),
			// Margin
			self::get_expand('m', array(
				self::get_tab(array(
					'n' => array(
					'options' => array(
						self::get_margin(' .counter-text', 'm_l')
					)
					),
					'h' => array(
					'options' => array(
						self::get_margin(' .counter-text', 'm_l', 'h')
					)
					)
				))
			)),
			// Border
			self::get_expand('b', array(
				self::get_tab(array(
					'n' => array(
					'options' => array(
						self::get_border(' .counter-text', 'b_l')
					)
					),
					'h' => array(
					'options' => array(
						self::get_border(' .counter-text', 'b_l', 'h')
					)
					)
				))
			)),
			// Rounded Corners
			self::get_expand('r_c', array(
				self::get_tab(array(
					'n' => array(
						'options' => array(
							self::get_border_radius(' .counter-text', 'r_c_l')
						)
					),
					'h' => array(
						'options' => array(
							self::get_border_radius(' .counter-text', 'r_c_l', 'h')
						)
					)
				))
			)),
			// Shadow
			self::get_expand('sh', array(
				self::get_tab(array(
					'n' => array(
						'options' => array(
							self::get_box_shadow(' .counter-text', 'sh_l')
						)
					),
					'h' => array(
						'options' => array(
							self::get_box_shadow(' .counter-text', 'sh_l', 'h')
						)
					)
				))
			)),
        );

        $number = array(
			self::get_expand('f', array(
			self::get_tab(array(
				'n' => array(
				'options' => array(
					self::get_font_family( ' .bc-timer', 'n_f' ),
					self::get_color_type( ' .bc-timer', 'n_c' ),
					self::get_font_size( ' .bc-timer', 'n_s' ),
					self::get_font_style( ' .bc-timer', 'n_fs', 'n_fw' ),
					self::get_line_height( ' .bc-timer', 'n_h' ),
					self::get_text_align( ' .bc-timer', 'n_a' ),
					self::get_text_shadow( ' .bc-timer', 'n_sh' ),
				)
				),
				'h' => array(
				'options' => array(
					self::get_font_family( ' .bc-timer', 'n_f_h' ),
					self::get_color_type( ' .bc-timer', 'n_c_h' ),
					self::get_font_size( ' .bc-timer', 'n_s_h' ),
					self::get_font_style( ' .bc-timer', 'n_fs', 'n_fw', 'h' ),
					self::get_text_shadow( ' .bc-timer', 'n_sh_h' ),
				)
				)
			))
			)),
        );

	return array(
		'type' => 'tabs',
		'options' => array(
			'g' => array(
			    'options' => $general
			),
			'm_t' => array(
			    'options' => $this->module_title_custom_style()
			),
			'n' => array(
				'label' => __('Number', 'builder-counter'),
				'options' => $number
			),
			'l' => array(
				'label' => __('Label', 'builder-counter'),
				'options' => $l
			)
		)
	    );
    }

	public static function get_translatable_text_fields( $module ) : array {
		return [ 'mod_title_counter', 'number_counter', 'number_grouping', 'label_counter', 'circle_percentage_counter' ];
	}
}

if(!method_exists( 'Themify_Builder_Component_Module', 'get_module_class' )){
	if ( method_exists( 'Themify_Builder_Model', 'add_module' ) ) {
		new TB_Counter_Module();
	} else {
		Themify_Builder_Model::register_module('TB_Counter_Module');
	}
}